# -*- coding: utf-8 -*-
"""
********************************************************************************
* Name:
* Author: Alan Lemon
* Created On: February 15, 2019
* Copyright: (c) Aquaveo 2019
* License: BSD 2-Clause
********************************************************************************
"""

import param


class HotStartDataSet(param.Parameterized):
    name = param.String(
        default='',
        doc="NAME: Data set name."
    )
    values = param.DataFrame(
        default=None,
        doc='Data set values. There is a value for each node in the mesh. If the data set represents vectors then '
            'there are 2 values for each node in the mesh.',
    )
    number_of_cells = param.Integer(
        default=1,
        bounds=(1, None),
        doc='NC: Number of cells. Not used by ADH but written and read from the file for consistency.',
    )
