"""TableCalc Class."""
__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.FhwaVariable.core_data.calculator.calculator import Calculator


class TableCalc(Calculator):
    """Class that defines a table and plot of related data."""

    def _compute_data(self):
        """Compute the data.

        Returns:
            True, if successful; otherwise, False
        """
        self.results = {}
        num_items = self.input_dict['calc_data']['Table options']['Number of items']
        for input in self.input_dict['calc_data']['Data input']:
            if isinstance(self.input_dict['calc_data']['Data input'][input], list):
                self.results[input] = self.input_dict['calc_data']['Data input'][input][:num_items]
            # self.results[input].set_val(self.input['Data input'].get_val().input[input].get_val()[:num_items])

        for plot_name in self.plot_dict:
            if 'series' not in self.plot_dict[plot_name]:
                continue
            for series in self.plot_dict[plot_name]['series']:
                x_var = self.plot_dict[plot_name]['series'][series]['x var']
                if x_var and x_var.name in self.results:
                    x_var.set_val(self.results[x_var.name])

                y_var = self.plot_dict[plot_name]['series'][series]['y var']
                if y_var and y_var.name in self.results and x_var and x_var.name != y_var.name:
                    y_var.set_val(self.results[y_var.name])

                yy_var = self.plot_dict[plot_name]['series'][series]['yy var']
                if yy_var and yy_var.name in self.results and x_var and x_var.name != yy_var.name:
                    yy_var.set_val(self.results[yy_var.name])

        #     plot_options = self.plot_dict[plot_name]
        #     table_plot_options = self.plot_dict[plot_name]['series'][0]
        #     # table_plot_options = plot_options.get_item_by_name(plot_name)
        #     # # if table_plot_options is None:
        #     # #     table_plot_options = plot_options.get_item_by_indices(0, 0)
        #     # if table_plot_options:
        #     result_keys = list(self.results.keys())
        #     if table_plot_options.x_var and table_plot_options.x_var.name in self.results:
        #         table_plot_options.x_var = self.results[table_plot_options.x_var.name]
        #     else:
        #         table_plot_options.x_var = self.results[result_keys[0]]

        #     if table_plot_options.y_var and table_plot_options.y_var.name in self.results and \
        #             table_plot_options.x_var and table_plot_options.x_var.name != table_plot_options.y_var.name:
        #         table_plot_options.y_var = self.results[table_plot_options.y_var.name]
        #     else:
        #         table_plot_options.y_var = self.results[result_keys[1]]
        #     plot_options.set_item_by_name(table_plot_options)
        return True

    def _get_can_compute(self, unknown=None):
        """Determines if there is enough data to make a computation and if there isn't, add a warning for each reason.

        Returns:
            bool: True if can compute
        """
        result = True
        self.warnings = {}

        return result

    def get_plot_options(self, plot_name):
        """Get the plot options.

        Args:
            plot_name (str): name of the plot

        Returns:
            dict: plot options
        """
        return self.input['Plot options'][plot_name].get_val()

    def get_plot_options_dict(self, plot_name):
        """Get the plot options.

        Args:
            plot_name (str): name of the plot

        Returns:
            dict: plot options
        """
        return self.get_plot_options(plot_name).get_plot_options_dict()
