"""Classes to Define the model-view of a plot."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import uuid

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


class Plot():
    """A class to define the model-view of a plot."""
    def __init__(self, plot_uuid: uuid.UUID = None):
        """Initialize the plot class."""
        self.uuid = plot_uuid
        if self.uuid is None:
            self.uuid = uuid.uuid4()

        self.plot_name = ''

        self.bg_color = (0, 0, 0)
        self.text_color = (255, 255, 255)
        self.xtick_color = (255, 255, 255)
        self.ytick_color = (255, 255, 255)

        self.is_equal_aspect = False

        self.is_grid = True

        self.min_x = None
        self.max_x = None
        self.min_y = None
        self.max_y = None

        self.x_units = ''
        self.y_units = ''
        self.xx_units = ''
        self.yy_units = ''
        self.x_axis_label = ''
        self.y_axis_label = ''
        self.yy_axis_label = ''

        self.null_data = -9999.0

        self.plot_options_dict = {}
