"""Classes to Define the model-view of the main interface."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import uuid

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
# from xms.FhwaVariable.core_data.calculator.tree_data import TreeData
# from xms.FhwaVariable.core_data.calculator.metadata import Metadata
from xms.FhwaVariable.interface_adapters.view_model.window_base import WindowBase


class Application(WindowBase):
    """A class to define the model-view of the main interface."""
    def __init__(self, app_uuid: uuid.UUID = None):
        """Initialize the main interface class."""
        self.uuid = app_uuid
        if self.uuid is None:
            self.uuid = uuid.uuid4()

        # options for tool: 'pan', 'zoom', 'rotate', 'select', 'measure'
        self.gui_tool = 'select'

        self.status_message = ''

        # Application data
        self.menu_bar = {}
        self.tool_bar = {}
        self.center_toolbar_names = []

        self.data_tree = []

        self.doc_windows = {}
        self.support_windows = []

        # Document windows layout
        # "tile", "cascade", "minimize all", "maximize all", "restore all"
        self.doc_windows_layout = "maximize all"
        # To add a snap_window_to_edge: [(uuid, edge), ...]
        self.snap_window_to_edge = None

        self.windows = {}

        self.undo_list = []
        self.redo_list = []

        # Application colors
        self.title_bg_color = (0, 0, 0)
        self.title_text_color = (255, 255, 255)
        self.bg_color = (0, 0, 0)
        self.text_color = (255, 255, 255)
        self.selected_bg_color = None
        self.selected_text_color = None
        self.hover_bg_color = None
        self.hover_text_color = None
        self.item_bg_color = (0, 0, 0)
        self.item_text_color = (255, 255, 255)
        self.doc_bg_color = (0, 0, 0)

        # Wiki
        self.show_wiki = True
        self.wiki_url = ""
