"""GradationManagerData Class."""
__copyright__ = "(C) Copyright Aquaveo 2020"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.FhwaVariable.core_data.calculator.calculator import Calculator
# from xms.FhwaVariable.core_data.calculator.calcdata import CalcData
# from xms.FhwaVariable.core_data.variables.variable import Variable

# 4. Local modules
# from xms.HydraulicToolboxCalc.hydraulics.bridge_scour.gradations.bore_hole_data import BoreHoleData
# from xms.HydraulicToolboxCalc.hydraulics.bridge_scour.gradations.bore_hole_manager_data import BoreHoleManagerData
from xms.HydraulicToolboxCalc.hydraulics.bridge_scour.gradations.bore_hole_manager_calc import BoreHoleManagerCalc


class GradationManagerCalc(Calculator):
    """Provides a class that will define a class that manages a list of gradation sets."""

    locations = BoreHoleManagerCalc.locations

    def get_gradation_dict(self, location):
        """Get the list of gradation sets."""
        # self.update_elevation_data()
        if location == 'Approach cross-section':
            if self.input_dict['calc_data']['Approach gradation input options'] == 'Single D50':
                return None
            else:
                return self.input_dict['calc_data']['Approach gradations']

        else:
            if self.input_dict['calc_data']['Contracted gradation input options'] == 'Single D50':
                return None
            else:
                return self.input_dict['calc_data']['Boreholes']

    def _compute_data(self):
        """Compute the data."""
        # self.update_elevation_data()
        self.results['Approach gradations'] = {}
        self.results['Contraction gradations'] = {}

        set = self.input_dict['calc_data']['Approach gradations']['calculator']
        set.compute_data_with_subdict(self.input_dict, self.input_dict['calc_data']['Approach gradations'])
        self.input_dict['calc_data']['Approach gradations']['Approach layer']['calculator'].compute_data_with_subdict(
            self.input_dict, self.input_dict['calc_data']['Approach gradations']['Approach layer'],
            plot_dict=self.plot_dict)
        name = 'Approach gradation(s)'
        if self.input_dict['calc_data']['Approach gradations']['Approach locations'] == \
                'Single gradation for entire cross-section':
            self.results['Approach gradations'][name] = {}
            self.results['Approach gradations'][name]['Data complete'] = set.can_compute
        else:
            self.input_dict['calc_data']['Approach gradations']['Left overbank layer'][
                'calculator'].compute_data_with_subdict(self.input_dict, self.input_dict['calc_data'][
                    'Approach gradations']['Left overbank layer'])
            self.input_dict['calc_data']['Approach gradations']['Right overbank layer'][
                'calculator'].compute_data_with_subdict(self.input_dict, self.input_dict['calc_data'][
                    'Approach gradations']['Right overbank layer'])
            can_compute_main = self.input_dict['calc_data']['Approach gradations']['Approach layer'][
                'calculator'].can_compute
            can_compute_left = self.input_dict['calc_data']['Approach gradations']['Left overbank layer'][
                'calculator'].can_compute
            can_compute_right = self.input_dict['calc_data']['Approach gradations']['Right overbank layer'][
                'calculator'].can_compute
            can_compute = can_compute_main and can_compute_left and can_compute_right

            name = self.input_dict['calc_data']['Approach gradations']['Approach layer']['Name']
            self.results['Approach gradations'][name] = {}
            self.results['Approach gradations'][name]['Data complete'] = can_compute

        name = 'Borehole(s)'
        all_compute = True
        if self.input_dict['calc_data']['Contracted gradation input options'] == 'Single D50':
            self.results['Contraction gradations'][name] = {}
            self.results['Contraction gradations'][name]['Data complete'] = set.can_compute
            self.results['Contraction gradations'][name]['Number of boreholes'] = 1
            return True
        elif self.input_dict['calc_data']['Contracted gradation input options'] == 'Single borehole':
            plot_dict = self.plot_dict
            if 'Gradations' in self.plot_dict and 'Single borehole' in self.plot_dict['Gradations']:
                plot_dict = self.plot_dict['Gradations']['Single borehole']
            elif 'Single borehole' in self.plot_dict:
                plot_dict = self.plot_dict['Single borehole']
            self.input_dict['calc_data']['Single borehole']['calculator'].\
                compute_data_with_subdict(self.input_dict, self.input_dict['calc_data']['Single borehole'],
                                          plot_dict=plot_dict)
            all_compute = self.input_dict['calc_data']['Single borehole']['calculator'].can_compute
        else:
            for index in self.input_dict['calc_data']['Boreholes']['Boreholes']:
                self.input_dict['calc_data']['Boreholes']['Boreholes'][index]['calculator'].\
                    compute_data_with_subdict(self.input_dict, self.input_dict['calc_data']['Boreholes'][
                        'Boreholes'][index])
                # if not self.input_dict['calc_data']['Boreholes']['Boreholes'][index]['calculator'].can_compute:
                #     all_compute = False
                #     break
        self.results['Contraction gradations'][name] = {}
        self.results['Contraction gradations'][name]['Data complete'] = all_compute
        self.results['Contraction gradations'][name]['Number of boreholes'] = \
            len(self.input_dict['calc_data']['Boreholes']['Boreholes'])

        return True
