"""ModelSettings Class."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.FhwaVariable.core_data.model.project_data.project_settings_base import ProjectSettingsCalc
from xms.FhwaVariable.core_data.model.project_data.settings.constants import ConstantDefinitions
from xms.FhwaVariable.core_data.variables.variable import Variable

# 4. Local modules
from xms.HydraulicToolboxCalc.model.settings.bridge_scour import BridgeScourSettings
from xms.HydraulicToolboxCalc.model.settings.calculation_numbers import CalculationNumbers
from xms.HydraulicToolboxCalc.model.settings.gradation_settings import GradationSettings


class HydraulicToolboxProjectSettings(ProjectSettingsCalc):
    """Provides definitions for the model settings."""

    def __init__(self, app_name: str = None, version: str = None, agency: str = None, developed_by: str = None):
        """Initializes the Hydraulic Toolbox Project.

        Args:
            app_name (str): The name of the project.
            version (float): The version of the project.
            agency (str): The agency that developed the project.
            developed_by (str): The company that developed the project.

        """
        super().__init__(app_name, version, agency, developed_by)

        self.input['Constant definitions'] = Variable('Constant definitions', 'class',
                                                      ConstantDefinitions(app_name, version, agency, developed_by))

        self.input['Calculation numbers'] = Variable('Calculation numbers', 'class',
                                                     CalculationNumbers(app_name, version, agency, developed_by))

        self.input['Gradation settings'] = Variable('Gradation settings', 'class',
                                                    GradationSettings(app_name, version, agency, developed_by))

        self.input['Bridgescour settings'] = Variable('Bridgescour settings', 'class',
                                                      BridgeScourSettings(app_name, version, agency, developed_by))
