"""Worker thread for the fort.13 exporter."""

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.guipy.dialogs.process_feedback_dlg import ProcessFeedbackThread

# 4. Local modules
from xms.adcirc.dmi.fort20_data_getter import Fort20DataGetter
from xms.adcirc.feedback.xmlog import XmLog
from xms.adcirc.file_io.fort20_writer import export_flow_to_fort20


class Fort20ExportWorkerThread(ProcessFeedbackThread):
    """Worker thread for exporting an ADCIRC fort.20 file."""
    def __init__(self, filename, query, parent):
        """Construct the worker.

        Args:
            filename (:obj:`str`): Path to the export location.
            query (:obj:`xms.api.dmi.Query`): Object for communicating with XMS
            parent (:obj:`QWidget`): Parent of the QThread
        """
        super().__init__(parent=parent, do_work=self._do_work)
        self.filename = filename
        self.query = query

    def _do_work(self):
        """Thread runner that exports the fort.20."""
        XmLog().instance.info('Exporting ADCIRC hydrographs...')
        try:
            xms_data = {}
            getter = Fort20DataGetter(self.query, xms_data)
            getter.retrieve_data()
            export_flow_to_fort20(self.filename, xms_data['bc_datas'])
        except Exception:
            XmLog().instance.exception('Error! Could not export ADCIRC hydrographs.')
