"""Get the package version."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
from packaging import version

# 3. Aquaveo modules

# 4. Local modules


def needs_update(file_version: str, changed_version: str) -> bool:
    """
    Determines whether a file needs to be updated based on its version and the changed version.

    Args:
        file_version (str): The version of the file.
        changed_version (str): The changed version.

    Returns:
        bool: True if the file needs to be updated, False otherwise.
    """
    file = version.parse(file_version)
    changed = version.parse(changed_version)
    return file < changed
