"""Python wrapping for xms.api._xmsapi.dmi.Context."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.api._xmsapi.dmi import Context as CContext


class Context:
    """The pure Python wrapper for C++ exposed xms.api._xmsapi.dmi.Context objects."""
    def __init__(self, instance=None):
        """Construct the wrapper.

        Note that this is a low-level API object that should not be constructed directly.

        Args:
            instance (xms.api._xmsapi.dmi.Context): The C++ object to wrap
        """
        if instance is None:
            self._instance = CContext()
        else:
            self._instance = instance

    @property
    def root_instance(self):
        """Returns the Context's root instance as an int."""
        return self._instance.GetRootInstance()

    @property
    def place_marks(self):
        """Get the currently enabled Context instance nodes.

        Returns:
            dict: Key is int Context instance id and value the nodes ContextVertexData
        """
        return self._instance.GetPlaceMarks()

    def get_parent(self, instance_id):
        """Returns the parent Context instance id of a specified instance id.

        Args:
            instance_id (int): The instance id of the child node

        Returns:
            int: Instance id of the specified node's parent, -1 if no parent found.
        """
        return self._instance.GetParent(instance_id)

    def clear_place_marks(self):
        """Set all currently active instance nodes in the Context to inactive."""
        self._instance.ClearPlaceMarks()

    def set_place_mark(self, instance_id, enable=True):
        """Set the state of an instance node in the Context.

        Args:
            instance_id (int): Id of the instance node to update
            enable (bool): True if the instance node should be enabled
        """
        self._instance.SetPlaceMark(instance_id, enable)

    def get_context_from_place_marks(self):
        """Get a trimmed down Context that only contains the currently active instance nodes and their ancestors.

        Returns:
            xms.api.dmi.Context: The trimmed Context
        """
        return Context(instance=self._instance.GetContextFromPlaceMarks())
