"""This is a table widget for specifying tidal constituents."""

# 1. Standard Python modules

# 2. Third party modules
from PySide2.QtWidgets import QAbstractItemView

# 3. Aquaveo modules
from xms.guipy.delegates.edit_field_validator import EditFieldValidator
from xms.guipy.delegates.qx_cbx_delegate import QxCbxDelegate
from xms.guipy.models.rename_model import RenameModel
from xms.guipy.validators.qx_double_validator import QxDoubleValidator

# 4. Local modules
from xms.cmsflow.data.bc_data import SUPPORTED_CONSTITUENTS
from xms.cmsflow.gui.cmsflow_table_widget import CmsflowTableWidget


class TidalTableWidget(CmsflowTableWidget):
    """Table widget base class."""
    def __init__(self, parent, data_frame):
        """Construct the widget.

        Args:
            parent (Something derived from :obj:`QObject`): The parent object.
            data_frame (pandas.DataFrame): The model data.

        """
        self.rename_model = None
        self.edit_delegate = None
        self.constituent_delegate = None
        self.dbl_validator = None
        super().__init__(parent, data_frame, 1, {'constituent': 'M2', 'amplitude': 0.0, 'phase': 0.0})

    def setup_ui(self):
        """Sets up the delegates, validators, and filter model for this table."""
        self.rename_model = RenameModel(['Constituent', 'Amplitude (m)', 'Phase (deg)'], self)
        self.dbl_validator = QxDoubleValidator(parent=self)
        self.edit_delegate = EditFieldValidator(self.dbl_validator)
        self.constituent_delegate = QxCbxDelegate(self)
        self.constituent_delegate.set_strings(SUPPORTED_CONSTITUENTS)
        delegates = {0: self.constituent_delegate, 1: self.edit_delegate, 2: self.edit_delegate}
        super()._setup_ui(delegates, False, False, self.rename_model)
        self.table_view.setEditTriggers(QAbstractItemView.AllEditTriggers)
