"""xmscomponents entry points for XMS."""
# 1. Standard Python modules
import argparse
import atexit

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.components.runners import migrate_runner
from xms.components.runners import pool_process
from xms.components.runners import run_runner
from xms.components.runners import ui_event


def main():
    """The main routine."""
    arguments = argparse.ArgumentParser(description="Component.")
    arguments.add_argument(dest='script', type=str, help='script to run')
    arguments.add_argument(dest='vars', nargs='*', help='other arguments')
    parsed_args = arguments.parse_args()
    if parsed_args.script == 'ui':
        ui_event.main()
    elif parsed_args.script == 'runner':  # Add a new process to the XMS Python pool
        process = pool_process.PoolProcess()
        process.wait_to_run()
    elif parsed_args.script == 'migrate':
        migrate_runner.main()
    elif parsed_args.script == 'launch':
        run_runner.main()


def _my_exit():
    """This hack is needed so our Python scripts don't hang with the SmartBear GUI testing framework."""
    from PySide2.QtWidgets import QApplication
    if QApplication.instance() is not None:
        import os
        if os.path.isfile('c:/temp/un_smarty_bear.txt'):
            os.remove('c:/temp/un_smarty_bear.txt')
            os._exit(0)  # bad idea but needed for testing
        elif os.path.isfile('c:/temp/un_smarty_bear_taskkill.txt'):
            # Also, a bad idea, but one above doesn't always work
            os.remove('c:/temp/un_smarty_bear_taskkill.txt')
            os.system(f'taskkill /PID {os.getpid()} /F')


if __name__ == "__main__":
    atexit.register(_my_exit)
    main()
