from xms.grid.ugrid import UGrid

from . import _xmsconstraint


class UGrid2dMerger:
    """Merge two UGrids containing only 2D cells."""
    def __init__(self, primary_ugrid=None, secondary_ugrid=None, instance=None):
        """Initializer for UGrid2dMerger. Must be given either two UGrids or a C++ instance.

        Args:
            primary_ugrid (UGrid): The first UGrid to merge. Will be given priority.
            secondary_ugrid (UGrid): The first UGrid to merge.
            instance (UGrid2dMerger): An optional C++ instance.
        """
        if primary_ugrid and secondary_ugrid:
            self._instance = _xmsconstraint.ugrid.UGrid2dMerger(primary_ugrid._instance, secondary_ugrid._instance)
        elif instance:
            self._instance = instance
        else:
            raise ValueError('Must provide two Ugrids or instance to merge.')

    def merge(self):
        """Merge the primary and secondary UGrids.

        Returns:
            UGrid: The merged UGrid
        """
        merge_ugrid = self._instance.Merge()
        if not merge_ugrid:
            raise ValueError('Unable to merge UGrids.')
        else:
            merge_ugrid = UGrid(instance=merge_ugrid)
        return merge_ugrid

    def secondary_point_indices_in_merged_ugrid(self):
        """Get the point indices of the secondary grid in the merged grid based on their original indices in the
        secondary grid.

        Returns:
            VecInt: indices of the secondary grid points in the merged UGrid
        """
        return self._instance.GetSecondaryUgridPtIndicesInMergedUGrid()
