"""Python wrapping for xms._data_objects.parameters.Point."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.data_objects._data_objects.parameters import Volume as CVolume


class Volume:
    """The pure Python wrapper for C++ exposed xms._data_objects.parameters.Volume objects."""

    def __init__(self, instance=None):
        """Construct the wrapper.

        Args:
            instance (xms._data_objects.parameters.Volume): The C++ object to wrap
        """
        if instance:
            self._instance = instance
        else:
            self._instance = CVolume()

    @property
    def id(self):
        """Returns the volume's XMS feature id."""
        return self._instance.GetId()

    @id.setter
    def id(self, volume_id):
        """Sets the volume's XMS feature id.

        Args:
            volume_id (int): Id to assign the volume
        """
        self._instance.SetId(volume_id)
