"""A dialog for displaying feature map lines."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
from PySide2 import QtCore
from PySide2.QtCore import QUrl
from PySide2.QtWebEngineWidgets import QWebEngineView
from PySide2.QtWidgets import QVBoxLayout

# 3. Aquaveo modules
from xms.guipy.dialogs.xms_parent_dlg import XmsDlg

# 4. Local modules


class MeshViewerDialog(XmsDlg):
    """A dialog for displaying feature map lines."""
    def __init__(self, parent, map_url, folium_map):
        """Initializes the class.

        Args:
            parent (:obj:`QWidget`): Parent dialog
            map_url (:obj:`dict`): Url for map.
            folium_map (:obj:`object`): Folium map for display
        """
        super().__init__(parent, 'xms.ewn.gui.mesh_viewer_dialog')
        self._widgets = {}
        self._folium_map = folium_map
        self._map_url = map_url

        self._setup_ui()

    def _setup_ui(self):
        """Setup the ui."""
        self.setWindowTitle('Preview Mesh')
        self.setWindowFlag(QtCore.Qt.WindowCloseButtonHint, False)
        self.setMinimumSize(500, 500)
        self._widgets['vert_layout'] = QVBoxLayout()
        self._widgets['mesh_view'] = QWebEngineView(self)
        self._widgets['vert_layout'].addWidget(self._widgets['mesh_view'])
        self.setLayout(self._widgets['vert_layout'])
        self.update_display()

    def update_display(self):
        """A method to update the display."""
        self._widgets['mesh_view'].setUrl(QUrl.fromLocalFile(self._map_url))
        self._widgets['mesh_view'].show()
