"""Script to export GenCade model."""

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


def main():
    """Writes the GenCade simulation to disk."""
    import os
    from xms.api.dmi import XmsEnvironment as XmEnv
    from xms.guipy.dialogs import xms_parent_dlg
    from xms.guipy.dialogs.process_feedback_dlg import LogEchoQSignalStream, ProcessFeedbackDlg
    from xms.gencade.components.export_simulation_runner import ExportSimulationRunner

    path = os.getcwd()
    worker = ExportSimulationRunner(out_dir=path)
    note = ''
    display_text = {
        'title': 'GenCade Export Simulation',
        'working_prompt': 'Exporting GenCade simulation files. Please wait...',
        'warning_prompt': 'Warning(s) encountered while exporting simulation. Review log output for more details.',
        'error_prompt': 'Error(s) encountered while exporting simulation. Review log output for more details.',
        'success_prompt': 'Successfully exported simulation',
        'note': note,
        'auto_load': 'Close this dialog automatically when exporting is finished.'
    }
    xms_parent_dlg.ensure_qapplication_exists()
    feedback_dlg = ProcessFeedbackDlg(display_text=display_text, logger_name='xms.gencade', worker=worker, parent=None)
    rval = feedback_dlg.exec()
    if rval:
        if LogEchoQSignalStream.logged_error:
            XmEnv.report_export_error()
    else:
        XmEnv.report_export_aborted()


if __name__ == "__main__":
    main()
