r"""
The file_io package contains the classes and functions for reading and writing GSSHA files.

+-----------------------+-------------------+-----------+-------------------------+-------------------------+
| File                  | Project File Card | Extension | Reader                  | Writer                  |
+=======================+===================+===========+=========================+=========================+
| Project file          |                   |  .gssha   | :mod:`.project_reader`  | :mod:`.project_writer`  |
+-----------------------+-------------------+-----------+-------------------------+-------------------------+
| Channel input         | CHAN_INPUT        |  .cif     | :mod:`.cif_file_reader` | :mod:`.cif_file_writer` |
+-----------------------+-------------------+-----------+-------------------------+-------------------------+
| Point source input    | CHAN_POINT_INPUT  |  .ihg     |                         | :mod:`.ihg_file_writer` |
+-----------------------+-------------------+-----------+-------------------------+-------------------------+
| Grid stream cell      | STREAM_CELL       |  .gst     |                         | :mod:`.gst_file_writer` |
+-----------------------+-------------------+-----------+-------------------------+-------------------------+
| Output hydrographs    | IN_HYD_LOCATION   |  .ihl     | :mod:`.ihl_file_reader` | :mod:`.ihl_file_writer` |
+-----------------------+-------------------+-----------+-------------------------+-------------------------+
| Mapping tables        | MAPPING_TABLE     |  .cmt     | :mod:`.cmt_file_reader` | :mod:`.cmt_file_writer` |
+-----------------------+-------------------+-----------+-------------------------+-------------------------+
| Stream mapping tables | ST_MAPPING_TABLE  |  .smt     |                         | :mod:`.smt_file_writer` |
+-----------------------+-------------------+-----------+-------------------------+-------------------------+
| Time series           | TIME_SERIES_FILE  |  .xys     | :mod:`.xys_file_reader` | :mod:`.xys_file_writer` |
+-----------------------+-------------------+-----------+-------------------------+-------------------------+
| Precipitation         | PRECIP_FILE       |  .gag     | :mod:`.gag_file_reader` | :mod:`.gag_file_writer` |
+-----------------------+-------------------+-----------+-------------------------+-------------------------+

"""
