"""Miscellaneous utility code.py."""

__copyright__ = '(C) Copyright Aquaveo 2024'
__license__ = 'All rights reserved'

# 1. Standard Python modules
from typing import Any

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


def bitwise_str(the_list: list[Any]) -> str:
    r"""Returns a string representing the binary value of a flag made by considering the args that are not None.

    Example: [1, 'bob', None, ''] -> '1101'

    Args:
        the_list: list of whatever
    """
    if not the_list:
        return ''

    flag = 0
    for i, arg in enumerate(reversed(the_list)):
        if arg is not None:
            flag += pow(2, i)
    return f'{flag:b}'
