"""
Test fixtures for dialogs.

If you want to use these in tests, you can put `pytest_plugins = ['xms.guipy.testing.fixtures']` in your `conftest.py`.
"""

__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
import pytest

# 3. Aquaveo modules

# 4. Local modules


@pytest.fixture(scope='session')
def running_multiple_tests(request) -> bool:
    """
    Check whether there are multiple tests in the current batch of tests.

    This is mainly used as a heuristic for dialog tests to decide whether they should leave the dialog open after the
    test finishes. If multiple tests are running, it's likely either the CI or a mass test to see what fails, and
    leaving dialogs open would be irritating at best. If only a single test is running though, it's probably being run
    manually because it failed and needs to be debugged, in which case leaving the dialog open is more likely to be a
    slight nuisance at worst.

    Some packages use a `running_tox` fixture instead. If you run PyTest directly, that fixture gives the OK to leave up
    tons of dialogs. Running outside of Tox can be nice because it's faster, and PyCharm integrates with it to let you
    run a subset of tests (like "only feedback tests", or "just the tests that failed last time").
    """
    # request.session.items is a list of all the tests that pytest decided should be run.
    return len(request.session.items) > 1
