"""Base class for display option button selectors with icons."""

# 1. Standard Python modules

# 2. Third party modules
from PySide2.QtCore import Property, Signal
from PySide2.QtWidgets import QButtonGroup, QWidget

# 3. Aquaveo modules

# 4. Local modules


class ButtonEnumWidget(QWidget):
    """Base class for display option button selectors with icons."""
    def __init__(self, parent=None):
        """Construct the widget.

        Args:
            parent (QObject): The Qt parent
        """
        super().__init__(parent)
        self.btn_group = QButtonGroup(self)
        self.btn_group.buttonClicked.connect(self.selection_changed)

    def read_value(self):
        """Get the current enum value of the button icon.

        Returns:
            (int): See description
        """
        return self.btn_group.checkedId()

    def set_value(self, val):
        """Set the current enum value of the button icon.

        Args:
            val (int): New icon enum for the button
        """
        btn = self.btn_group.button(val)
        if btn:
            btn.setChecked(True)

    @Signal
    def selection_changed(self):
        """Do nothing slot for when icon changes."""
        pass

    enum_value = Property(int, read_value, set_value, user=True)
