"""OpropsWriter class."""

__copyright__ = '(C) Copyright Aquaveo 2024'
__license__ = 'All rights reserved'

# 1. Standard Python modules

# 2. Third party modules
# from overrides import overrides

# 3. Aquaveo modules

# 4. Local modules
from xms.hgs.data.domains import Domains
from xms.hgs.file_io.props_writer_base import PropsWriterBase
from xms.hgs.file_io.section import IndentedSection


class OpropsWriter(PropsWriterBase):
    """Writes the .oprops file (surface water domain material properties)."""
    def __init__(self, materials_data, material_lookup, grok_filepath) -> None:
        """Initializes the class.

        Args:
            materials_data: Materials data dict.
            material_lookup: Dict of materials data arranged in a more useful way.
            grok_filepath (Path): Path to the .grok file.
        """
        super().__init__(materials_data, material_lookup, grok_filepath)
        self._domain = Domains.OLF  # self._domain is defined in PropsWriterBase

    # @overrides
    def _write_material(self, i: int, material_name: str, uuid: str) -> None:
        heading = f'! material {i + 1}\n{material_name}'
        with IndentedSection(self._file_data, heading=heading, end_text='! material') as section:
            section.write_widgets('x friction', 'edt')
            section.write_widgets('y friction', 'edt')
            section.write_widgets('time varying friction', 'btn')
            section.write_widgets('rill storage height', 'edt')
            section.write_widgets('obstruction storage height', 'edt')
            section.write_widgets('coupling length', 'edt')
            section.write_widgets('maximum flow depth', 'edt')
            section.write_widgets('read rill storage from raster', sub_widget_list=['edt_raster_filename'])
            section.write_widgets('scale factor', 'edt')
