"""EslComponent class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
from pathlib import Path

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.components.package_component_base import PackageComponentBase


class EslComponent(PackageComponentBase):
    """A Dynamic Model Interface (DMI) component for an ESL (Energy Source Loading) package."""
    def __init__(self, main_file):
        """Initializes the class.

        Args:
            main_file: The main file associated with this component.
        """
        super().__init__(main_file)
        self.ftype = 'ESL6'  # package ftype
        if Path(self.main_file).is_file():
            self.ensure_disp_opts_file_exists()
