"""RchAndEvtWriterBase class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import copy

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.file_io.gwf.array_package_writer import ArrayPackageWriter
from xms.mf6.file_io.list_package_writer import ListPackageWriter
from xms.mf6.file_io.package_writer_base import PackageWriterBase


class RchAndEvtWriterBase(PackageWriterBase):
    """Writes the package to disk."""
    def __init__(self):
        """Initializes the class."""
        super().__init__()

    def _write_package(self, data):
        """Reads the file.

        Args:
            data: The data class (EvtPackageData or RchPackageData).
        """
        if data.options_block.has('READASARRAYS'):
            writer = ArrayPackageWriter()
        else:
            writer = ListPackageWriter()

        writer._write_log_message = False  # The thing calling this already wrote the log message
        writer._writer_options = copy.deepcopy(self._writer_options)
        writer.write(data)
