"""IcWriter class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.data.ic_data import IcData
from xms.mf6.file_io.griddata_package_writer import GriddataPackageWriter


class IcWriter(GriddataPackageWriter):
    """Writes a IC package file."""
    def __init__(self):
        """Initializes the class."""
        super().__init__()

    def _set_strt(self, data):
        """If the GMS option to set STRT to cell tops is true, does that."""
        if not data.gms_options or not data.gms_options.get(IcData.STRT_EQUALS_TOPS, False):
            return
        dis = data.model.get_dis()
        data.set_strt_equal_to_top(dis)

    def _write_package(self, data):
        """Writes the package.

        Args:
            data (MfsimData): the modflow simulation
        """
        self._set_strt(data)
        super()._write_package(data)
