"""PestObsReader class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import os

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.file_io.package_reader import PackageReader


class PestObsReader(PackageReader):
    """Reads the PEST observations file."""
    def __init__(self):
        """Initializes the class."""
        super().__init__(ftype='POBS6')

    def _on_end_file(self):
        """Called when done reading the file."""
        # Save the name of the component folder so we can copy files from it when we save.
        self._data.component_folder = os.path.dirname(self._data.filename)
