"""Simulation import script."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
from typing import Optional

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import Query, XmsEnvironment as XmEnv
from xms.components.dmi.xms_data import XmsData
from xms.guipy.dialogs.process_feedback_dlg import run_feedback_dialog

# 4. Local modules
from xms.ptm.feedback.import_sim_thread import ImportSimThread


def main(query: Optional[Query] = None):  # pragma: no cover
    """Entry point wrapper."""
    try:
        query = query or Query()
        data = XmsData(query)
        worker = ImportSimThread(data)
        run_feedback_dialog(worker)
    except Exception as ex:
        XmEnv.report_error(ex)


if __name__ == "__main__":  # pragma: no cover
    main()
