"""Uses CoverageMapper to map data to SRH mesh."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import logging

# 2. Third party modules
from PySide2.QtCore import QThread, Signal

# 3. Aquaveo modules

# 4. Local modules
from xms.srh.components.sim_query_helper import SimQueryHelper
from xms.srh.mapping.coverage_mapper import CoverageMapper


class CoverageMapperRunner(QThread):
    """Class for mapping material coverage to a mesh for SRH-2D."""
    processing_finished = Signal()

    def __init__(self, query):
        """Constructor."""
        super().__init__()
        self._query = query
        self._logger = logging.getLogger('xms.srh')
        self.query_helper = None

    def run(self):
        """Creates the snap preview of coverages onto the mesh."""
        try:
            self.query_helper = SimQueryHelper(self._query)
            self.query_helper.get_sim_data()
            self.query_helper.get_3d_structure_data()

            worker = CoverageMapper(self.query_helper, generate_snap=True)
            worker.do_map()

            self.query_helper.mapped_comps = worker.mapped_comps
        except:  # noqa
            self._logger.exception('Error generating snap.')
        finally:
            self.processing_finished.emit()
