"""Exports SRH simulation."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import logging
import os
import time

# 2. Third party modules
from PySide2.QtCore import QThread, Signal

# 3. Aquaveo modules
from xms.api.dmi import Query  # noqa: I202

# 4. Local modules
from xms.srh.file_io import file_writer


class ExportSimulationRunner(QThread):
    """Class for exporting SRH-2D."""
    processing_finished = Signal()

    def __init__(self, out_dir):
        """Constructor.

        Args:
            out_dir (:obj:`str`): output directory
        """
        super().__init__()
        self.out_dir = os.path.normpath(out_dir)
        self._logger = logging.getLogger('xms.srh')
        self.query = None

    def run(self):
        """Exports the model files."""
        try:
            self._setup_query()
            file_writer.write(self.query, self.out_dir, self._logger)
        finally:
            self.processing_finished.emit()

    def _setup_query(self):
        self._logger.info('Establishing communication with SMS.')
        time.sleep(0.1)
        self.query = Query()
