"""BcDataArcs class."""

__copyright__ = "(C) Copyright Aquaveo 2019"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
import param

# 3. Aquaveo modules
from xms.guipy.param.param_enabler import ParamEnabler  # noqa: I202

# 4. Local modules


class BcDataArcs(param.Parameterized):
    """Manages arcs for structures."""
    arc_id_0 = param.Integer(
        default=-1,
        doc='id of first arc',
        precedence=-2,
    )
    arc_id_1 = param.Integer(
        default=-1,
        doc='id of second arc',
        precedence=-1,
    )
    arc_option_0 = param.ObjectSelector(
        label='Arc id - ##',
        default='Upstream',
        objects=['Upstream', 'Downstream'],
        doc='',
        precedence=1,
    )
    arc_option_1 = param.ObjectSelector(
        label='Arc id - ##',
        default='Downstream',
        objects=['Upstream', 'Downstream'],
        doc='',
        precedence=2,
    )

    def __init__(self):
        """Initializes the class."""
        super().__init__()
        self.doing_update = False
        self.enabler = ParamEnabler(
            param_cls=self,
            enablers=[],
            depends={},
        )

    @param.depends('arc_id_0', watch=True)
    def _update_arc_id_0(self):
        """Watches changes made to the arc_id_0 object."""
        self.param['arc_option_0'].label = f'Arc id - {self.arc_id_0}'
        self.enabler.do_enabling(force_disable=False)

    @param.depends('arc_id_1', watch=True)
    def _update_arc_id_1(self):
        """Watches changes made to the arc_id_1 object."""
        self.param['arc_option_1'].label = f'Arc id - {self.arc_id_1}'
        self.enabler.do_enabling(force_disable=False)

    @param.depends('arc_option_0', watch=True)
    def _update_arc_option_0(self):
        """Watches changes made to the arc_option_0 object."""
        if self.doing_update:
            return
        self.doing_update = True
        if self.arc_option_0 == 'Upstream' and self.arc_option_1 != 'Downstream':
            self.arc_option_1 = 'Downstream'
        elif self.arc_option_1 != 'Upstream':
            self.arc_option_1 = 'Upstream'
        self.enabler.do_enabling(force_disable=False)
        self.doing_update = False

    @param.depends('arc_option_1', watch=True)
    def _update_arc_option_1(self):
        """Watches changes made to the arc_option_1 object."""
        if self.doing_update:
            return
        self.doing_update = True
        if self.arc_option_1 == 'Upstream' and self.arc_option_0 != 'Downstream':
            self.arc_option_0 = 'Downstream'
        elif self.arc_option_0 != 'Upstream':
            self.arc_option_0 = 'Upstream'
        self.enabler.do_enabling(force_disable=False)
        self.doing_update = False
