"""Script used to run SRH."""

__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import Query  # noqa: I202
from xms.srh.srh_run import RunSRH

# 4. Local modules
from xms.srh_swmm_coupler.dmi.xms_data import CouplerData


class SimRunner(RunSRH):
    """Says what SRH executables will run."""
    def __init__(self, dummy_mainfile=''):
        """Constructor."""
        super().__init__()
        query = Query()
        xms_data = CouplerData(query)
        super().set_sim_uuid(xms_data.srh_sim[0].uuid)
