"""Model native export script."""

__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules
import os
from typing import Optional

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import Query, XmsEnvironment as XmEnv
from xms.guipy.dialogs.process_feedback_dlg import run_feedback_dialog

# 4. Local modules
from xms.srh_swmm_coupler.feedback.simulation_export_runner import SimulationExportRunner


def main(query: Optional[Query] = None):
    """Entry point wrapper."""
    try:
        path = os.getcwd()
        worker = SimulationExportRunner(query, out_dir=path)
        run_feedback_dialog(worker)
    except Exception as ex:
        XmEnv.report_error(ex)


if __name__ == "__main__":  # pragma: no cover
    main()
