"""Utility methods used by the GUI modules."""

__copyright__ = "(C) Copyright Aquaveo 2019"
__license__ = "All rights reserved"

# 1. Standard Python modules
import datetime
import os

# 2. Third party modules
from PySide2.QtCore import QDate, QDateTime, QTime

# 3. Aquaveo modules
from xms.api.dmi import XmsEnvironment as XmEnv

# 4. Local modules


def datetime_to_qdatetime(dt_literal):
    """Convert a Python datetime object to a QDateTime.

    Args:
        dt_literal (datetime.datetime): Datetime to convert

    Returns:
        (QDateTime): See description
    """
    return QDateTime(
        QDate(dt_literal.year, dt_literal.month, dt_literal.day),
        QTime(dt_literal.hour, dt_literal.minute, dt_literal.second)
    )


def qdatetime_to_datetime(qdatetime):
    """Convert a QDateTime to a Python datetime object.

    Args:
        qdatetime (QDateTime): QDateTime to convert

    Returns:
        (datetime.datetime): See description
    """
    return datetime.datetime(
        year=qdatetime.date().year(),
        month=qdatetime.date().month(),
        day=qdatetime.date().day(),
        hour=qdatetime.time().hour(),
        minute=qdatetime.time().minute(),
        second=qdatetime.time().second()
    )


def logging_filename(filename):
    """Get a filename for logging purposes.

    Args:
        filename (str): Absolute path to the file or directory

    Returns:
        str: The normalized filepath if not testing, or the filename's basename if testing
    """
    if XmEnv.xms_environ_running_tests() == 'TRUE':
        return os.path.basename(filename)
    return os.path.normpath(filename)
