"""Qt delegate for the standard constituent combobox column of the user defined constituents table."""
# 1. Standard python modules

# 2. Third party modules
from PySide2.QtWidgets import QComboBox

# 3. Aquaveo modules
from xms.guipy.delegates.qx_cbx_delegate import QxCbxDelegate

# 4. Local modules


class ConstituentButtonDelegate(QxCbxDelegate):
    """Delegate for the constituent button column."""
    def __init__(self, options, parent=None):
        """Initializes the class.

        Args:
            options (list): List of str combobox options
            parent (QObject): The parent object.
        """
        super().__init__(parent)
        self._strings = options

    def createEditor(self, parent, option, index):  # noqa N802
        """Creates the combobox and populates it.

        Args:
            parent (QWidget): The parent.
            option (QStyleOptionViewItem): The option
            index (QModelIndex): The index

        Returns:
            QWidget: The editor combobox
        """
        self.cb = QComboBox(parent)
        self.cb.addItems(self._strings)
        self.cb.currentIndexChanged.connect(self.on_index_changed)
        return self.cb
