"""PolygonFromRasterBoundsTool class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.tool_core import IoDirection, Tool

# 4. Local modules
from xms.tool.algorithms.coverage import PolygonFromRasterBounds

ARG_INPUT_RASTER = 0
ARG_OUTPUT_COVERAGE = 1


class PolygonFromRasterBoundsTool(Tool):
    """Tool to make a coverage with polygons for the interior active regions of the input raster."""

    def __init__(self):
        """Initializes the class."""
        super().__init__(name='Polygon from Raster Bounds')

    def initial_arguments(self):
        """Get initial arguments for tool.

        Must override.

        Returns:
            (list): A list of the initial tool arguments.
        """
        arguments = [
            self.raster_argument(name='input_raster', description='Input raster'),
            self.coverage_argument(name='output_coverage', description='Output coverage',
                                   io_direction=IoDirection.OUTPUT)
        ]
        return arguments

    def run(self, arguments):
        """Override to run the tool.

        Args:
            arguments (list): The tool arguments.
        """
        input_raster = self.get_input_raster(arguments[ARG_INPUT_RASTER].value)
        out_cov = arguments[ARG_OUTPUT_COVERAGE].value

        polygon_creator = PolygonFromRasterBounds(input_raster, out_cov, self.default_wkt, self.vertical_datum,
                                                  self.vertical_units, self.logger)
        boundary_cov = polygon_creator.create_boundary_coverage()
        if not boundary_cov.empty:
            self.set_output_coverage(boundary_cov, arguments[ARG_OUTPUT_COVERAGE])
