"""A dialog for displaying feature map lines."""

__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
import folium

# 3. Aquaveo modules

# 4. Local modules


class DisplayParameters():
    """A class to store the display info so that we can avoid reframing when we want."""
    def __init__(self):
        """Initializes the class."""
        self.lat = None
        self.long = None
        self.zoom = None
        self.x_min = None
        self.x_max = None
        self.y_min = None
        self.y_max = None


def clear_geometry(url_file):
    """Draw the levee BC coverage in the map.

    Args:
       url_file (string): URL file for drawing
    """
    folium_map = folium.Map(tiles='')
    folium.map.LayerControl().add_to(folium_map)
    # Use io, rather than a file on disk, to store the map as html in memory
    folium_map.save(url_file)
