"""Weir Class."""
__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules
from pathlib import Path

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.FhwaVariable.core_data.calculator.setting_group import SettingGroup
from xms.FhwaVariable.core_data.calculator.variable_group import VariableGroup
from xms.FhwaVariable.core_data.variables.variable import Variable


class PersonalDetails(SettingGroup):
    """A base class that defines the personal details of a user, person, or organization."""

    def __init__(self, name: str = 'HydraulicToolbox', version: str = '0.1', agency: str = 'FHWA',
                 developed_by: str = 'Aquaveo',):
        """Initializes the CalcData."""
        super().__init__(name, version, agency, developed_by)

        self.stand_alone_calc = True

        self.unknown = None

        # organization_strings = []  # Get the available organizations
        self.state_short_strings = ['AL', 'AK', 'AZ', 'AR', 'CA', 'CO', 'CT', 'DE', 'DC', 'FL', 'GA', 'HI', 'ID', 'IL',
                                    'MA', 'MI', 'MN', 'MS', 'MO', 'MT', 'NE', 'NV', 'NH', 'NJ', 'NM', 'NY', 'NC', 'ND',
                                    'OH', 'OK', 'OR', 'PA', 'PR', 'RI', 'SC', 'SD', 'TN', 'TX', 'UT', 'VT', 'VA', 'VI',
                                    'WA', 'WV', 'WI']
        self.state_strings = ['Alabama', 'Alaska', 'Arizona', 'Arkansas', 'California', 'Colorado', 'Connecticut',
                              'Delaware', 'District of Columbia', 'Florida', 'Georgia', 'Hawaii', 'Idaho', 'Illinois',
                              'Indiana', 'Iowa', 'Kansas', 'Kentucky', 'Louisiana', 'Maine', 'Maryland',
                              'Massachusetts', 'Michigan', 'Minnesota', 'Mississippi', 'Missouri', 'Montana',
                              'Nebraska', 'Nevada', 'New Hampshire', 'New Jersey', 'New Mexico', 'New York',
                              'North Carolina', 'North Dakota', 'Ohio', 'Oklahoma', 'Oregon', 'Pennsylvania',
                              'Puerto Rico', 'Rhode Island', 'South Carolina', 'South Dakota', 'Tennessee', 'Texas',
                              'Utah', 'Vermont', 'Virginia', 'Virgin Islands', 'Washington', 'West Virginia',
                              'Wisconsin', 'Wyoming']
        # Get the available organizations
        self.input['Profile picture'] = Variable('Profile picture', 'image', None, VariableGroup.image_filters)
        self.input['Profile picture'].file_mode = 'existing file'
        self.input['Name'] = Variable('Full Name', 'string', "", [])
        # Suffixes?
        self.input['Biography'] = Variable('Biography', 'string', "", [])

        self.input['Organization'] = Variable('Organization', 'list', 0, [])
        self.input['Use organization address'] = Variable('Use the organization address', 'bool', True, [])

        self.input['Address'] = Variable('Street address', 'string', "", [])
        self.input['City'] = Variable('City', 'string', "", [])
        self.input['State'] = Variable('State', 'list', 0, self.state_strings)
        self.input['Zip'] = Variable('Zipcode', 'zip', '', [])

        self.input['Phone'] = Variable('Phone number', 'phone', "", [])
        self.input['Email'] = Variable('E-mail', 'email', '', [])
        self.input['Website'] = Variable('Website', 'url', '', [])
        self.input['Use organization website'] = Variable('Use the organization website', 'bool', True, [])

        self.input['LinkedIn'] = Variable('LinkedIn', 'string', '', [])
        self.input['Facebook'] = Variable('Facebook', 'string', '', [])
        self.input['X'] = Variable('X', 'string', '', [])
        self.input['Instagram'] = Variable('Instagram', 'string', '', [])
        self.input['Qr'] = Variable('Qr code', 'image', None, VariableGroup.image_filters)
        self.input['Stamp'] = Variable('Professional stamp', 'image', None, VariableGroup.image_filters)
        self.input['Professional number'] = Variable(
            'Professional number', 'int', 0, [])  # as in a professional engineer number

    def get_filename(self):
        """The filename to write or read, if calc_save_on_accept is True."""
        return Path('')

    def get_input_group(self, unknown=None):
        """Returns the input group for the user interface.

        Args:
            unknown (string): variable that is unknown

        Returns:
            input_vars (list of variables): input group for the user interface's input table
        """
        # input_vars = {}
        input_vars = self.input

        return input_vars

    def get_results_group(self, unknown=None):
        """Returns a dictionary of input variables that are needed for current selections.

        Args:
            unknown (string): the variable that is unknown (and included in the result dictionary)

        Returns:
              result_vars (dictionary of variables): the input variables
        """
        result_vars = {}

        if not self.get_can_compute():
            return result_vars

        return result_vars

    def check_warnings(self):
        """Checks for warnings that are given during computations or a check if we can compute (get_can_compute).

        Returns:
            list of str: The warnings found (if any)
        """
        warning = None
        if warning:
            self.warnings.append(warning)
        return self.warnings

    def get_can_compute(self, unknown=None):
        """Determines if there is enough data to make a computation and if there isn't, add a warning for each reason.

        Returns:
            bool: True if can compute
        """
        result = True
        self.warnings = []

        return result

    def compute_data(self):
        """Computes the data possible; stores results in self.

        Returns:
            bool: True if successful
        """
        return False

    def setup_plot_data(self, axes, index, show_axis_titles, plot_name, can_compute=None):
        """Setup the plot data.

        Args:
            axes (AxesSubplot): The plot axes
            index (int): index of flow to display
            show_axis_titles (bool): whether to show the titles of the axes
            plot_name (str): name of the plot
            can_compute (bool): whether we can compute
        """
        pass
