"""Classes to Define the model-view of a plot."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
from dataclasses import dataclass, field
from uuid import UUID, uuid4

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


@dataclass
class Plot:
    """A class to define the model-view of a plot."""
    plot_uuid: UUID | None = None
    plot_name: str = ''
    bg_color: tuple[int, int, int] = (0, 0, 0)
    text_color: tuple[int, int, int] = (255, 255, 255)
    xtick_color: tuple[int, int, int] = (255, 255, 255)
    ytick_color: tuple[int, int, int] = (255, 255, 255)
    is_equal_aspect: bool = False
    is_grid: bool = True
    min_x: float | None = None
    max_x: float | None = None
    min_y: float | None = None
    max_y: float | None = None
    x_units: str = ''
    y_units: str = ''
    xx_units: str = ''
    yy_units: str = ''
    x_axis_label: str = ''
    y_axis_label: str = ''
    yy_axis_label: str = ''
    null_data: float = -9999.0
    plot_options_dict: dict = field(default_factory=dict)
    uuid: UUID = field(init=False)

    def __post_init__(self):
        """Initialize UUID after other fields are set. Generates a new UUID if plot_uuid is None."""
        self.uuid = self.plot_uuid if self.plot_uuid is not None else uuid4()
