"""Functions for performing functionality on lists."""
__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules
import math

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


def remove_nans(x_data: list[float], y_data: list[float], null_data: float, n_data: list[float] = None
                ) -> tuple[list[float], list[float], list[float]]:
    """Remove NaNs from the data.

    Args:
        x_data (list): The x data
        y_data (list): The y data

    Returns:
        list: The cleaned x data
        list: The cleaned y data
    """
    cleaned_x_data = []
    cleaned_y_data = []
    cleaned_n_data = [] if n_data is not None else None
    index = 0
    for x, y in zip(x_data, y_data):
        if not math.isnan(x) and not math.isnan(y) and x != null_data and y != null_data:
            cleaned_x_data.append(float(x))
            cleaned_y_data.append(float(y))
            if n_data is not None and index < len(n_data):
                cleaned_n_data.append(float(n_data[index]))
        index += 1
    return cleaned_x_data, cleaned_y_data, cleaned_n_data
