"""This module for writes an mp file for CMS-Flow."""

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import Query

# 4. Local modules
from xms.cmsflow._cmsflow_mp_export import CMSFlowMpExporter
from xms.cmsflow.dmi.xms_data import XmsData

if __name__ == "__main__":
    import traceback
    try:
        query = Query()
        data = XmsData(query)
        exporter = CMSFlowMpExporter(data)
        exporter.export()
    except Exception as ex:
        with open('mp_export_error.txt', 'a') as f:
            traceback.print_exception(type(ex), ex, ex.__traceback__, file=f)
        raise ex
