"""This is a table widget for specifying wind paramters."""

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.guipy.delegates.edit_field_validator import EditFieldValidator
from xms.guipy.models.rename_model import RenameModel
from xms.guipy.validators.qx_double_validator import QxDoubleValidator

# 4. Local modules
from xms.cmsflow.gui.cmsflow_table_widget import CmsflowTableWidget


class WindParametersTableWidget(CmsflowTableWidget):
    """Table widget base class."""
    def __init__(self, parent, data_frame):
        """Construct the widget.

        Args:
            parent (Something derived from :obj:`QObject`): The parent object.
            data_frame (pandas.DataFrame): The model data.

        """
        self.rename_model = None
        self.edit_delegate = None
        self.dbl_validator = None
        super().__init__(parent, data_frame, 0, {'time': 0.0, 'direction': 0.0, 'velocity': 0.0})

    def setup_ui(self):
        """Sets up the delegates, validators, and filter model for this table."""
        self.rename_model = RenameModel(['Time (hr)', 'Direction (deg)', 'Velocity (m/s)'], self)
        self.dbl_validator = QxDoubleValidator(parent=self)
        self.edit_delegate = EditFieldValidator(self.dbl_validator)
        delegates = {0: self.edit_delegate, 1: self.edit_delegate, 2: self.edit_delegate}
        super()._setup_ui(delegates, False, False, self.rename_model)
