from .. import _xmsconstraint
from ..grid_reader import _grid_from_cpp_co_grid


def get_stacked_grid_2d_topology(ugrid):
    """Get the 2D topology of a stacked grid.

    Args:
        ugrid: The UGrid that has been previously determined to be
            stacked.

    Returns:
        (tuple):
            A two-tuple with the first element containing the locations
            of the points. The second element contains a two dimensional
            array giving the cell points.
    """
    xm_ugrid = ugrid._instance
    return _xmsconstraint.modflow.modflow_geometry_utils.\
        mfGetStackedGrid2dTopology(xm_ugrid)


def build_stacked_grid_from_2d(locations_2d, clockwise_cells, num_cell_layers):
    """Build a 3D constrained grid from MODFLOW 6 locations and cells.

    Args:
        locations_2d: The locations from MODFLOW 6. testing
        clockwise_cells: A 2D array of the cell points.
        num_cell_layers: The number of cell layers.

    Returns:
        The 3D constrained UGrid.
    """
    co_grid_types = _xmsconstraint.modflow.modflow_geometry_utils.\
        mfBuildStackedGridFrom2d(locations_2d, clockwise_cells,
                                 num_cell_layers)
    return _grid_from_cpp_co_grid(co_grid_types)
