from . import GridType
from . import _xmsconstraint
from .quadtree_grid_2d import QuadtreeGrid2d
from .quadtree_grid_3d import QuadtreeGrid3d
from .rectilinear_data import RectilinearData
from .quadtree import QuadGridCells


class QuadtreeGridBuilder(RectilinearData):
    """Builder for a quad tree constrained UGrid."""

    def __init__(self):
        instance = _xmsconstraint.constraint.CoQuadtreeGridBuilder()
        RectilinearData.__init__(self, instance)

    @property
    def quad_grid_cells(self):
        """The QuadGridCells which give the cell refinement."""
        return QuadGridCells(instance=self._instance.GetQuadGridCells())

    @quad_grid_cells.setter
    def quad_grid_cells(self, quad_grid_cells):
        """The QuadGridCells which give the cell refinement."""
        self._instance.SetQuadGridCells(quad_grid_cells._instance)

    def build_grid(self):
        """Build the specified grid.

        Returns:
            The quad tree constrained UGrid.
        """
        grid = self._instance.BuildGrid()
        if grid.GetGridType() == GridType.quadtree_2d:
            return QuadtreeGrid2d(grid)
        elif grid.GetGridType() == GridType.quadtree_3d:
            return QuadtreeGrid3d(grid)
        raise ValueError('Unable to build quadtree grid.')
