"""ProgressTracker class."""

__copyright__ = '(C) Copyright Aquaveo 2024'
__license__ = 'All rights reserved'

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import Query

# 4. Local modules


class ProgressTracker:
    """Class to keep track of progress as the simulation runs."""
    prog = None
    query = None
    echo_file = None
    echo_pos = 0
    total_ts = 0

    def __init__(self):
        """Initializes the class."""
        pass

    @staticmethod
    def calculate_progress(curr_period, curr_ts):
        """Calculates the progress at a given timestep.

        Also a helper function for progress_function.

        Args:
            curr_period (int): The current stress period
            curr_ts (int): The current time step of the current stress period

        Returns:
            (float): Progress as a percent of all stress_periods.
        """
        return 100.0

    @staticmethod
    def progress_function():
        """Progress is calculated and sent to query as a percentage."""
        if not ProgressTracker.echo_file:
            ProgressTracker.echo_file = ProgressTracker.prog.command_line_output_file

    @staticmethod
    def start_tracking():
        """Entry point for the progress script."""
        ProgressTracker.query = Query(progress_script=True, timeout=300000)
        session = ProgressTracker.query.xms_agent.session
        if not session:
            return

        ProgressTracker.prog = session.progress_loop
        ProgressTracker.prog.set_progress_function(ProgressTracker.progress_function)
        ProgressTracker.prog.start_loop()
