"""TvaData class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.data.gwf.array_package_data import ArrayPackageData
from xms.mf6.data.options_block import OptionsBlock
from xms.mf6.gui.options_defs import Checkbox, CheckboxButton


class TvaData(ArrayPackageData):
    """Data class to hold the info from a TVA6 time variable array file."""
    def __init__(self, **kwargs):
        """Initializes the class.

        Args:
            **kwargs: Arbitrary keyword arguments.

        Keyword Args:
            ftype (str): The file type used in the GWF name file (e.g. 'WEL6')
            mfsim (MfsimData): The simulation.
            model (GwfData or GwtData): The GWF/GWT model. Will be None for TDIS, IMS, Exchanges (things below mfsim)
            grid_info (GridInfo): Information about the grid. Only used when testing individual packages. Otherwise,
             it comes from model and dis.
        """
        super().__init__(**kwargs)
        self.ftype = 'TVA6'

    def dialog_title(self) -> str:
        """Returns the title to show in the dialog.

        Returns:
            (str): The dialog title.
        """
        return ''

    def is_layer_indicator(self, array_name) -> bool:
        """Returns True if the array is a layer indicator ('IEVT', 'IRCH').

        Returns:
            (bool): True or False
        """
        return False

    def array_supports_time_array_series(self, array_name) -> bool:
        """Returns True if the array can have time-array series.

        Returns:
            (bool): True or False
        """
        return False

    # @overrides
    def _setup_options(self):
        """Returns the definition of all the available options.

        Returns:
            (OptionsBlock): See description.
        """
        netcdf_brief = 'Input griddata arrays will be written to the model output netcdf file'
        return OptionsBlock(
            [
                CheckboxButton(
                    'AUXILIARY',
                    button_text='Auxiliary Variables...',
                    check_box_method='on_chk_auxiliary',
                    button_method='on_btn_auxiliary'
                ),
                Checkbox('PRINT_INPUT', brief='Print input to listing file'),
                CheckboxButton(
                    'TAS6 FILEIN', brief='Time-series files', button_text='Files...', button_method='on_btn_ts6_filein'
                ),
                Checkbox('EXPORT_ARRAY_NETCDF', brief=netcdf_brief),
            ]
        )
