"""GncWriter class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.file_io import io_util
from xms.mf6.file_io.list_package_writer import ListPackageWriter


class GncWriter(ListPackageWriter):
    """Writes a list package file."""
    def __init__(self):
        """Initializes the class."""
        super().__init__()
        self._data = None  # ListPackageData

    def _write_dimensions(self, fp):
        """Writes the dimensions block.

        Args:
            fp (_io.TextIOWrapper): The file.
        """
        self._data.maxbound = 0
        if 'GNCDATA' in self._data.list_blocks:
            self._data.maxbound = io_util.count_max_line([self._data.list_blocks['GNCDATA']])
        fp.write('\n')
        fp.write('BEGIN DIMENSIONS\n')
        fp.write(f'{io_util.mftab}NUMGNC {self._data.maxbound}\n')
        fp.write(f'{io_util.mftab}NUMALPHAJ {self._data.numalphaj}\n')
        fp.write('END DIMENSIONS\n')

    def _write_package(self, data):
        """Writes the package file.

        Saves stress period data in external files using the OPEN/CLOSE option.
        """
        self._data = data
        with open(self._data.filename, 'w') as fp:
            self._write_comments(fp)
            self._write_options(fp)
            self._write_dimensions(fp)
            self._write_list_block('GNCDATA', fp)
