"""EventFilter class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
from PySide2.QtCore import QEvent, QObject

# 3. Aquaveo modules

# 4. Local modules


class EventFilter(QObject):
    """Event filter object. Used to prevent user from leaving number fields blank."""
    def __init__(self, dialog=None, *args):
        """Initializes the class."""
        QObject.__init__(self, *args)
        self.dialog = dialog

    def eventFilter(self, obj, event):  # noqa N802 (function name 'eventFilter' should be lowercase)
        """Gets called for every event this object is connected to.

        Args:
            obj: Qt object associated with the event.
            event: The QEvent object.

        Returns:
            (bool): True if the event was handled.
        """
        if event.type() == QEvent.FocusOut:
            self.dialog.on_constant()
            return QObject.eventFilter(self, obj, event)
        else:
            return QObject.eventFilter(self, obj, event)
