"""LakDialog class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.gui.advanced_package_dialog import AdvancedPackageDialog
from xms.mf6.gui.options_gui import OptionsGui


class LakDialog(AdvancedPackageDialog):
    """A dialog used for the LAK package."""
    def __init__(self, dlg_input, parent=None):
        """Initializes the class, sets up the ui, and loads the simulation.

        Args:
            dlg_input (DialogInput): Information needed by the dialog.
            parent (Something derived from QWidget): The parent window.
        """
        super().__init__(dlg_input, parent)

    # @overrides
    def setup_options(self, vlayout):
        """Sets up the options section, which is defined dynamically, not in the ui file.

        Args:
            vlayout (QVBoxLayout): The layout that the option widgets will be added to.
        """
        self.options_gui = OptionsGui(self)
        self.options_gui.setup(vlayout)

    def _get_aux_widget(self):
        """Returns the widget that includes aux columns (PeriodListWidget or ListBlockTableWidget).
        """
        return self.get_table_widget('PACKAGEDATA')

    def change_columns(self, use_aux):
        """Changes a table's columns given the list of auxiliary variables.

        Args:
            use_aux (bool): True to include AUXILIARY variables.
        """
        table_widget = self.get_table_widget('PACKAGEDATA')
        if table_widget:
            table_widget.change_columns('PACKAGEDATA', use_aux=use_aux)
