"""InletQParameter class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.srh.components.parameters.bc_parameter import BcParameter


class InletQParameter(BcParameter):
    """Represents a parameter used in ParametersManager and the Advanced Simulation dialog."""
    def __init__(
        self,
        use=0,
        id_number=-1,
        description='',
        default=0.0,
        string_value='',
        value=0.0,
        optimized_value=0.0,
        min=0.0,
        max=0.0
    ):
        """Initializes the class.

        Args:
            use (int): 1 if using this parameter, 0 if not
            id_number (int): Number used in the id_string.
            type (str): E.g. "Manning's N", 'Inlet Q', 'Exit H', 'Time step', 'Initial condition'
            description (str): Typically the arc number, or material name.
            default (float): default value
            string_value (str): string value
            value (float): value
            optimized_value (float): optimized value
            min (float): min
            max (float): max
        """
        super().__init__(
            use, id_number, 'Inlet Q', description, default, string_value, value, optimized_value, min, max
        )

    def id_string(self):
        """Returns a string for use in the 'id' column.

        Returns:
            (str): See description.
        """
        return f'inlet_q_{self.id_number}'

    def calibratable(self):
        """Returns True if the parameter can be used for calibration.

        Returns:
            (bool): See description.
        """
        return True
