"""BcDataWeirType class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
import param

# 3. Aquaveo modules
from xms.guipy.param.param_enabler import ParamEnabler  # noqa: I202

# 4. Local modules


class BcDataWeirType(param.Parameterized):
    """Bc type weir-type data."""
    type = param.ObjectSelector(
        default='Paved',
        objects=['Paved', 'Gravel', 'Single', 'Double', 'Sharp', 'Broad', 'User'],
        doc='',
        precedence=1,
    )
    cw = param.Number(
        default=0.0,
        doc='',
        precedence=2,
    )
    a = param.Number(
        label='a',
        default=0.0,
        doc='',
        precedence=3,
    )
    b = param.Number(
        label='b',
        default=0.0,
        doc='',
        precedence=4,
    )

    def __init__(self):
        """Initializes the class."""
        super().__init__()
        self.enabler = ParamEnabler(
            param_cls=self,
            enablers=['type'],
            depends={
                'User': ['cw', 'a', 'b'],
            },
        )

    @param.depends('type', watch=True)
    def _update_type(self):
        """Watches changes made to the type object."""
        self.enabler.do_enabling(force_disable=False)
