"""Dialog for viewing a pandas dataframe."""

__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
import pandas as pd

# 3. Aquaveo modules
from xms.guipy.dialogs.xms_parent_dlg import XmsDlg
from xms.guipy.models.qx_pandas_table_model import QxPandasTableModel

# 4. Local modules
from xms.srh_swmm_coupler.gui.dataframe_viewer_ui import Ui_DataframeViewer


class DataframeViewer(XmsDlg):
    """Dialog for viewing a pandas dataframe."""

    def __init__(self, df: pd.DataFrame, title: str, parent=None):
        """Initializes the dialog.

        Args:
            df (pd.DataFrame): The pandas dataframe to display.
            title (str): The dialog title.
            parent (:obj:`QObject`): The parent.
        """
        super().__init__(parent, 'xms.srh_swmm_coupler.gui.dataframe_viewer')
        self.ui = Ui_DataframeViewer()
        self.ui.setupUi(self)
        self.setWindowTitle(title)
        model = QxPandasTableModel(df)
        model.set_read_only_columns(set(range(0, len(df.columns))))
        self.ui.table_data.setModel(model)
