"""Worker thread for the spatial datasets exporter."""

# 1. Standard Python modules
import logging
import os

# 2. Third party modules

# 3. Aquaveo modules
from xms.guipy.dialogs.process_feedback_dlg import ProcessFeedbackThread

# 4. Local modules
from xms.stwave.file_io.dataset_writer import export_all_datasets, retrieve_xms_data
from xms.stwave.gui.gui_util import logging_filename


class SpatialExportWorkerThread(ProcessFeedbackThread):
    """Worker thread for exporting STWAVE spatial datasets."""

    def __init__(self, query, parent):
        """Construct the worker.

        Args:
            query (xms.api.dmi.Query): Object for communicating with XMS
            parent (QWidget): Parent of the QThread
        """
        super().__init__(parent=parent, do_work=self._do_work)
        self._query = query
        self._logger = logging.getLogger('xms.stwave')

    def _do_work(self):
        """Thread runner that exports the spatial dataset files."""
        self._logger.info('Exporting STWAVE spatial datasets...')
        try:
            self._logger.info('Retrieving spatial datasets from SMS...')
            xms_data = retrieve_xms_data(self._query)
            self._logger.info('Writing spatial datasets to specified location...')
            export_all_datasets(xms_data)
            self._logger.info(f'Successfully exported STWAVE spatial datasets to "{logging_filename(os.getcwd())}".')
        except Exception:
            self._logger.exception('Error! Could not export STWAVE spatial datasets.')
